(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)

(* Tilte: 
    Nonlinear Regression Analysis for Segregation Distortion in F2 
      Intercross *)

(* :Context: Application`SegregAnalysis`   *)

(* :Name:SegregAnalysis` *)

(* :Author: Yoshiaki Harushima *)

(* :Summary:
			This package performs segregation distortion analysis by Newton-
        Gauss nonlinear regression methods. 
*)

(* :History:
			Version 0.0, September 1997 
		 Version 1.0, February 1998
	  Version 1.1, March 1998 add zygotic model
	  Version 1.2, June 2000 add option for FixedParameter
		*)

(* :Sources:
			John M. Novak, NonlinearFit`, (a Mathematica package)
	*)

(* :Discussion:  *)

BeginPackage[
	"SegAnalysis`SegregAnalysis`",
	(* needed for subroutine *)
	"SegAnalysis`Single`",
	"SegAnalysis`OneOne`",
	"SegAnalysis`Two`",
	"SegAnalysis`TwoOne`",
	"SegAnalysis`Three`",
	"SegAnalysis`TwoTwo`",
	"SegAnalysis`ThreeOne`",
	"SegAnalysis`ThreeTwo`",
	"SegAnalysis`ThreeThree`",
	"SegAnalysis`ZOne`",
	"SegAnalysis`SingleZOne`",
	"SegAnalysis`ZTwo`",
	(* needed for graph *)
	"Graphics`MultipleListPlot`"
]

(*    *)
SegregAnalysis::usage = 
  "SegregAnalysis[dataA, dataB, dataH, renge, model, guess, {opts}] searches \
for positions and strengths of the segregation distortion genes by a \
least-squares fitting to lists of data within the renge according to the \
modele.  The modele is seven cases:Single, OneOne, Two, TwoOne, TwoTwo, \
ThreeTwo, ThreeThree, ZOne, SingleZOne and ZTwo.  The guess is expressed as a \
list of the initial guess for the position and strength of the segregation \
distortion gene or a list of lists, where each guess is listed :{position, \
strength}.  The dataA, dataB and dataH can have the form {{x1, A1}, {x2, A2}, \
...},  {{x1, B1}, {x2, B2}, ...},  and {{x1, H1}, {x2, H2}, ...}.  "

Options[SegregAnalysis] = 
  Sort[Join[
		{AccuracyGoal -> Automatic, 
     Gradient -> Automatic, 
		MaxIterations -> 30, 
     PrecisionGoal -> Automatic, 
		Weights -> Equal, 
     WorkingPrecision -> $MachinePrecision,
		FixedParameters ->{}}, 
    Options[LinearSolve]]]

Single::usage = 
  "Single is a value of the model. Single model assumes a singe gene that \
trnsmits A genotype by t1 at the gene positition x1 to explain the marker \
segregation distortions on the chromosome."

OneOne::usage=
  "OneOne is a value of the model. OneOne model assumes two genes on the \
different gamate to explain the marker segregation distortions on the \
chromosome.  The genes trnsmit A genotype by t1 and t2 at the gene positition \
x1 and x2, respectively."
		
Two::usage=
  "Two is a value of the model. Two model assumes two genes on the same \
gamate to explain the marker segregation distortions on the chromosome.  The \
genes trnsmit A genotype by t1 and t2 at the gene positition x1 and x2, \
respectively."

TwoOne::usage=
  "TwoOne is a value of the model. TwoOne model assumes three genes to \
explain the marker segregation distortions on the chromosome. Two genes {x1, \
t1} {x2, t2} are on the same gametes and another one {x3, t3} is on the \
different gamate. "

TwoTwo::usage=
  "TwoTwo is a value of the model. TwoTwo model assumes four genes to explain \
the marker segregation distortions on the chromosome. Two genes, {x1, t1} \
{x2, t2}, are on the same gametes and other two genes, {x3, t3} {x4, t4}, are \
on the different gamate. "

ThreeOne::usage=
  "ThreeOne is a value of the model. ThreeOne model assumes four genes to \
explain the marker segregation distortions on the chromosome. Three genes, \
{x1, t1} {x2, t2} {x3, t3} are on the same gametes and another gene, {x4, \
t4}, is on the different gamate. "

ThreeTwo::usage=
  "ThreeTwo is a value of the model. ThreeTwo model assumes five genes to \
explain the marker segregation distortions on the chromosome. Three genes, \
{x1, t1} {x2, t2} {x3, t3} , are on the same gametes and other two genes, \
{x4, t4} {x5, t5}, are on the different gamate. "

ThreeThree::usage=
  "ThreeThree is a value of the model. ThreeThree model assumes six genes to \
explain the marker segregation distortions on the chromosome. Three genes, \
{x1, t1} {x2, t2} {x3, t3} , are on the same gametes and other two genes, \
{x4, t4} {x5, t5} {x6, t6}, are on the different gamate. "

ZOne::usage = 
  "ZOne is a value of the model. ZOne model assumes one gene that affects \
viability of zygote to explain the marker segregation distortions on the \
chromosome.  The guess should be {gene position, relative viability of B \
homozygote to A homozygote, relative viability of H homozygote to A \
homozygote}." 

SingleZOne::usage = 
  "SingleZOne is a value of the model. SingleZOne model assumes a gametephyte \
gene and a zygotic viability gene to explain the marker segregation \
distortions on the chromosome.  The guess should be {{gametephyte gene \
position, transmittance of A gamete}, {gene position, relative viability of B \
homozygote to A homozygote, relative viability of H homozygote to A \
homozygote}}."

ZTwo::usage = 
  "ZTwo is a value of the model. ZTwo model assumes two genes that affect \
viability of zygote to explain the marker segregation distortions on the \
chromosome.  The guess should be {{gene position1, relative viability1 of B \
homozygote to A homozygote, relative viability1 of H homozygote to A \
homozygote}, {gene position2, relative viability2 of B homozygote to A \
homozygote, relative viability2 of H homozygote to A homozygote}}."

Begin["`Private`"]

(* ==== SegregAnalysis warning messages =====  *)

SegregAnalysis::baddataA = 
  "The dataA argument of SegregAnalysis must be a vector."

SegregAnalysis::baddataB = 
  "The dataB argument of SegregAnalysis must be a vector."

SegregAnalysis::baddataH = 
  "The dataH argument of SegregAnalysis must be a vector."

SegregAnalysis::badmodel = 
  "Warning: Model `1` is not available for SegregAnalysis;  using one of the \
model: Single, Two, OneOne, TwoOne, TwoTwo, ThreeOne, ThreeTwo, ZOne, \
SingleZOne, ZTwo."

SegregAnalysis::badrenge = 
  "The renge argument of SegregAnalysis must be `1` < `2`."

SegregAnalysis::degrees = 
  "Warning: The data set is smaller than the number of parameters."

SegregAnalysis::badits =
"Warning: MaxIterations -> `1` is not set to a positive integer;
setting to 30."

SegregAnalysis::badwork =
"Warning: The value `1` given for the WorkingPrecision is not an integer or \
is
an integer less than $MachinePrecision.  Setting to $MachinePrecision."

SegregAnalysis::badprec =
"Warning: The value `1` given for the PrecisionGoal is not a positive integer
or Automatic.  Setting to $MachinePrecision - 10."

SegregAnalysis::badacc =
"Warning: The value `1` given for the AccuracyGoal is not a positive integer
or Automatic.  Setting to $MachinePrecision - 10."

(* ===  SegregAnalysis fatal error messages === *)

SegregAnalysis::fitfail = "The fitting algorithm failed."

SegregAnalysis::badguess = 
  "In the case of Single, guess should be {position, stregth}. For Tow or \
OneOne, guess should be {{position1, strength1}, {position2, strength}} and \
position1 <= position2. For ZOne guess should be {position, B viablity, H \
viability}.  For ZTwo guess should be {{position1, B viablity1, H \
viability1}, {position2, B viablity2, H viability2}}.  For SingleZone guess \
should be {{G-position, G-stregth}, {Z-position, B viability, H viability}}.  \
Your guess is ``"
	
(* =========  SegregAnalysis ===========  *)

(* SegregAnalysis arguments;
	   dataA - matrix of numbers;
	   dataB - matrix of numbers;
	   dataH - matrix of numbers;
	   renge - the renge to fit modele equations;
	   model - the models for the segregation distortion;
	   guess - the initial guess for gene position and strength;
	   opts - the options
		*)
		
SegregAnalysis[dataA_List, dataB_List, dataH_List, renge_List, model_, 
    guess_List, (opts___)?OptionQ]:=Module[{result, check}, 
    (
			result 
		)			/; (check = Check[
					 Module[{irenge, iguess}, 
					irenge = N[renge]; iguess = N[guess];
          
                result = 
                  segregAnalysis[dataA, dataB, dataH,irenge, model, iguess, 
                    opts]; 
           result =!= $Failed
						], False,SegregAnalysis::fitfail];
				 check)
	] /; If[MatrixQ[N[dataA], NumberQ] || VectorQ[N[dataA], NumberQ], True, 
     Message[SegregAnalysis::baddataA]; False] && 
    If[MatrixQ[N[dataB], NumberQ] || VectorQ[N[dataB], NumberQ], True, 
     Message[SegregAnalysis::baddataB]; False] && 
    If[MatrixQ[N[dataH], NumberQ] || VectorQ[N[dataH], NumberQ], True, 
     Message[SegregAnalysis::baddataH]; False] && 
    If[MemberQ[{Single, OneOne, Two, TwoOne, TwoTwo, ThreeOne, ThreeTwo, 
            ThreeThree, ZOne, SingleZOne, ZTwo}, model], True, 
        Message[SegregAnalysis::badmodel,model]; False]


(* =========   segregAnalysis ==============  *)

segregAnalysis[dataA_, dataB_, dataH_, renge_, model_, guess_, opts___] := 
  Module[{fixparams, maxits, workprec, accgoal, precgoal, modulus, zerotest, 
      minrenge, maxrenge, rdataA, rdataB, rdataH, ptsA, ptsB, ptsH, 
      responseA, responseB, responseH, prec, nptsA, nptsB, nptsH, x1, t1, x2, 
      t2, x3, t3, x4, t4, x5, t5, x6, t6, xv1, vb1, vh1, xv2, vb2, vh2, 
      nresponseA, nresponseB, nresponseH, nx1, nt1, nx2, nt2, nx3, nt3, nx4, 
      nt4, nx5, nt5, nx6, nt6, nxv1, nvb1, nvh1, nxv2, nvb2, nvh2},
		(* Get options *) 
   {fixparams, maxits, workprec, accgoal, precgoal, modulus, zerotest} = 
     {FixedParameters, MaxIterations, WorkingPrecision, AccuracyGoal, 
            PrecisionGoal, Modulus, ZeroTest} /. 
				{opts} /.  Options[SegregAnalysis]; 
		(* Get and check renge *)
		 {minrenge, maxrenge} = renge;
    If[!(minrenge ===-Infinity || NumberQ[minrenge]) || 
      !(maxrenge === Infinity || NumberQ[maxrenge]) || 
      minrenge >= maxrenge, 
     Message[SegregAnalysis::badrenge, minrenge, maxrenge]; Return[$Failed]];
		(*  - check guess *)
		Which[
			model === Single,
			{x1, t1} = guess;
			If[VectorQ[guess, !NumberQ],
				Message[SegregAnalysis::badguess, guess]; Return[$Failed]],
			model === Two,
			{{x1, t1}, {x2, t2}} = guess;
			If[(MatrixQ[guess, !NumberQ] || x1 >= x2),
				Message[SegregAnalysis::badguess, guess]; Return[$Failed]],
			model === OneOne,
			{{x1, t1}, {x2, t2}} = guess;
			If[(MatrixQ[guess, !NumberQ] || x1 > x2),
				Message[SegregAnalysis::badguess, guess]; Return[$Failed]],
			model === TwoOne,
			{{x1, t1}, {x2, t2}, {x3, t3}} = guess;
			If[(MatrixQ[guess, !NumberQ] || x1 >= x2),
				Message[SegregAnalysis::badguess, guess]; Return[$Failed]],
			model === TwoTwo,
			{{x1, t1}, {x2, t2}, {x3, t3},  {x4, t4}} = guess;
			If[(MatrixQ[guess, !NumberQ] || x1 >= x2 || x3 >= x4),
				Message[SegregAnalysis::badguess, guess]; Return[$Failed]],
			model === ThreeOne,
			{{x1, t1}, {x2, t2}, {x3, t3},  {x4, t4}} = guess;
			If[(MatrixQ[guess, !NumberQ] || x1 >= x2 || x2 >= x3),
				Message[SegregAnalysis::badguess, guess]; Return[$Failed]],
			model === ThreeTwo,
			{{x1, t1}, {x2, t2}, {x3, t3}, {x4, t4}, {x5, t5}} = guess;
			If[(MatrixQ[guess, !NumberQ] || x1 >= x2 || x2 >= x3 || x4 >= x5),
				Message[SegregAnalysis::badguess, guess]; Return[$Failed]],
			model === ThreeThree,
			{{x1, t1}, {x2, t2}, {x3, t3}, {x4, t4}, {x5, t5}, {x6, t6}} = guess;
			If[(MatrixQ[guess, !NumberQ] || x1 >= x2 || x2 >= x3 || x4 >= x5 || 
            x5 >= x6),
				Message[SegregAnalysis::badguess, guess]; Return[$Failed]],
			model === ZOne,
			{xv1, vb1, vh1} = guess;
			If[VectorQ[guess, !NumberQ],
				Message[SegregAnalysis::badguess, guess]; Return[$Failed]],
			model === SingleZOne,
			{{x1, t1}, {xv1, vb1, vh1}} = guess;
			If[MatrixQ[guess, !NumberQ],
				Message[SegregAnalysis::badguess, guess]; Return[$Failed]],
			model === ZTwo,
			{{xv1, vb1, vh1},{xv2, vb2, vh2}} = guess;
			If[MatrixQ[guess, !NumberQ],
				Message[SegregAnalysis::badguess, guess]; Return[$Failed]]
			]; (* Which[ *)
		
(* Select data by renge *)  
rdataA = Select[dataA, minrenge < #1[[1]] < maxrenge & ];
rdataB = Select[dataB, minrenge < #1[[1]] < maxrenge & ];
rdataH = Select[dataH, minrenge < #1[[1]] < maxrenge & ];
(*  - assume univariate response *)
responseA = Last /@ rdataA;
ptsA = Flatten[(Take[#1, 1] & ) /@ rdataA];
responseB = Last /@ rdataB;
ptsB = Flatten[(Take[#1, 1] & ) /@ rdataB];
responseH = Last /@ rdataH;
ptsH =  Flatten[(Take[#1, 1] & ) /@ rdataH];
(* - check degrees of freedom *) 
Which[
			model === Single,
      If[ Length[ptsA] + Length[ptsB] + Length[ptsH] < 2-Length[fixparams], 
        Message[SegregAnalysis::degrees]],
			model === Two,
			If[ Length[ptsA] + Length[ptsB] + Length[ptsH] < 4-Length[fixparams], 
        Message[SegregAnalysis::degrees]],
			model === OneOne,
			If[ Length[ptsA] + Length[ptsB] + Length[ptsH] < 4-Length[fixparams], 
        Message[SegregAnalysis::degrees]],
			model === TwoOne,
			If[ Length[ptsA] + Length[ptsB] + Length[ptsH] < 6-Length[fixparams], 
        Message[SegregAnalysis::degrees]],
			model === TwoTwo,
			If[ Length[ptsA] + Length[ptsB] + Length[ptsH] < 8-Length[fixparams], 
        Message[SegregAnalysis::degrees]],
			model === ThreeOne,
			If[ Length[ptsA] + Length[ptsB] + Length[ptsH] < 8-Length[fixparams], 
        Message[SegregAnalysis::degrees]],
			model === ThreeTwo,
			If[ Length[ptsA] + Length[ptsB] + Length[ptsH] < 10-Length[fixparams], 
        Message[SegregAnalysis::degrees]],
			model === ThreeThree,
			If[ Length[ptsA] + Length[ptsB] + Length[ptsH] < 12-Length[fixparams], 
        Message[SegregAnalysis::degrees]],
			model === ZOne,
			If[ Length[ptsA] + Length[ptsB] + Length[ptsH] < 3-Length[fixparams], 
        Message[SegregAnalysis::degrees]],
			model === SingleZOne,
			If[ Length[ptsA] + Length[ptsB] + Length[ptsH] < 5-Length[fixparams], 
        Message[SegregAnalysis::degrees]],
			model === ZTwo,
			If[ Length[ptsA] + Length[ptsB] + Length[ptsH] < 6-Length[fixparams], 
        Message[SegregAnalysis::degrees]]
		];
(*    *)
If[ !(IntegerQ[maxits] && Positive[maxits]), 
     Message[SegregAnalysis::badits, maxits]; maxits = 30];
If[ !(IntegerQ[workprec] && 
        workprec >= $MachinePrecision), 
     Message[SegregAnalysis::badwork, workprec]; 
      workprec = $MachinePrecision];
If[precgoal === Automatic, precgoal = workprec - 10]; 
If[accgoal === Automatic, accgoal = workprec - 10]; 
If[ !(IntegerQ[precgoal] && Positive[precgoal]), 
     Message[SegregAnalysis::badprec, precgoal]; 
      precgoal = $MachinePrecision - 10]; 
If[ !(IntegerQ[accgoal] && Positive[accgoal]), 
     Message[SegregAnalysis::badacc, accgoal]; 
      accgoal = $MachinePrecision - 10];
(* - set working precision of inputs *)
(* Note: need the precision of the argument function to be at least as large 
          as WorkingPrecision *) 
nptsA = N[ptsA, workprec];
nresponseA = N[responseA, workprec];
nptsB = N[ptsB, workprec];
nresponseB = N[responseB, workprec];
nptsH = N[ptsH, workprec];
nresponseH = N[responseH, workprec];
		(* - call proper fitting routine *) 
Which[
			model === Single,
			nx1 = N[x1, workprec]; nt1 = N[t1, workprec];
			out = SegAnalysis`Single`Private`mnlr[nptsA,  nptsB, nresponseA, 
          nresponseB, nresponseH, nx1, nt1, fixparams, maxits, workprec, 
          precgoal, accgoal, modulus, zerotest];
			If[out =!= $Failed, Return[MakeOutputList[Single, out]]],
			model === Two,
			nx1 = N[x1, workprec]; nt1 = N[t1, workprec];
			nx2 = N[x2, workprec]; nt2 = N[t2, workprec];
			out = SegAnalysis`Two`Private`mnlr[nptsA, nptsB, nresponseA, nresponseB, 
          nresponseH, nx1, nt1, nx2, nt2, fixparams, maxits, workprec, 
          precgoal, accgoal, modulus, zerotest];
			If[out =!= $Failed, Return[MakeOutputList[Two, out]]],
			model === OneOne,
			nx1 = N[x1, workprec]; nt1 = N[t1, workprec];
			nx2 = N[x2, workprec]; nt2 = N[t2, workprec];
			out = SegAnalysis`OneOne`Private`mnlr[nptsA, nptsB, nptsH, nresponseA, 
          nresponseB, nresponseH, nx1, nt1, nx2, nt2, fixparams, maxits, 
          workprec, precgoal, accgoal, modulus, zerotest];
			If[out =!= $Failed, Return[MakeOutputList[OneOne, out]]],
			model ===TwoOne,
			nx1 = N[x1, workprec]; nt1 = N[t1, workprec];
			nx2 = N[x2, workprec]; nt2 = N[t2, workprec];
			nx3 = N[x3, workprec]; nt3 = N[t3, workprec];
			out = SegAnalysis`TwoOne`Private`mnlr[nptsA, nptsB, nptsH, nresponseA, 
          nresponseB, nresponseH, nx1, nt1, nx2, nt2, nx3, nt3, fixparams, 
          maxits, workprec, precgoal, accgoal, modulus, zerotest];
			If[out =!= $Failed, Return[MakeOutputList[TwoOne, out]]],
			model ===TwoTwo,
			nx1 = N[x1, workprec]; nt1 = N[t1, workprec];
			nx2 = N[x2, workprec]; nt2 = N[t2, workprec];
			nx3 = N[x3, workprec]; nt3 = N[t3, workprec];
			nx4 = N[x4, workprec]; nt4 = N[t4, workprec];
			out = SegAnalysis`TwoTwo`Private`mnlr[nptsA, nptsB, nptsH, nresponseA, 
          nresponseB, nresponseH, nx1, nt1, nx2, nt2, nx3, nt3, nx4, nt4, 
          fixparams, maxits, workprec, precgoal, accgoal, modulus, zerotest];
			If[out =!= $Failed, Return[MakeOutputList[TwoTwo, out]]],
			model ===ThreeOne,
			nx1 = N[x1, workprec]; nt1 = N[t1, workprec];
			nx2 = N[x2, workprec]; nt2 = N[t2, workprec];
			nx3 = N[x3, workprec]; nt3 = N[t3, workprec];
			nx4 = N[x4, workprec]; nt4 = N[t4, workprec];
			out = SegAnalysis`ThreeOne`Private`mnlr[nptsA, nptsB, nptsH, nresponseA, 
          nresponseB, nresponseH, nx1, nt1, nx2, nt2, nx3, nt3, nx4, nt4, 
          fixparams, maxits, workprec, precgoal, accgoal, modulus, zerotest];
			If[out =!= $Failed, Return[MakeOutputList[ThreeOne, out]]],
			model ===ThreeTwo,
			nx1 = N[x1, workprec]; nt1 = N[t1, workprec];
			nx2 = N[x2, workprec]; nt2 = N[t2, workprec];
			nx3 = N[x3, workprec]; nt3 = N[t3, workprec];
			nx4 = N[x4, workprec]; nt4 = N[t4, workprec];
			nx5 = N[x5, workprec]; nt5 = N[t5, workprec];
			out = SegAnalysis`ThreeTwo`Private`mnlr[nptsA, nptsB, nptsH, nresponseA, 
          nresponseB, nresponseH, nx1, nt1, nx2, nt2, nx3, nt3, nx4, nt4, 
          nx5, nt5, fixparams, maxits, workprec, precgoal, accgoal, modulus, 
          zerotest];
			If[out =!= $Failed, Return[MakeOutputList[ThreeTwo, out]]],
			model ===ThreeThree,
			nx1 = N[x1, workprec]; nt1 = N[t1, workprec];
			nx2 = N[x2, workprec]; nt2 = N[t2, workprec];
			nx3 = N[x3, workprec]; nt3 = N[t3, workprec];
			nx4 = N[x4, workprec]; nt4 = N[t4, workprec];
			nx5 = N[x5, workprec]; nt5 = N[t5, workprec];
			nx6 = N[x6, workprec]; nt6 = N[t6, workprec];
			out = SegAnalysis`ThreeThree`Private`mnlr[nptsA, nptsB, nptsH, nresponseA, 
          nresponseB, nresponseH, nx1, nt1, nx2, nt2, nx3, nt3, nx4, nt4, 
          nx5, nt5, nx6, nt6, fixparams, maxits, workprec, precgoal, accgoal, 
          modulus, zerotest];
			If[out =!= $Failed, Return[MakeOutputList[ThreeThree, out]]],
			model ===ZOne,
			nxv1 = N[xv1, workprec];
			nvb1 = N[vb1, workprec]; nvh1 = N[vh1, workprec];
			out =SegAnalysis`ZOne`Private`mnlr[nptsA, nptsB, nptsH, nresponseA, 
          nresponseB, nresponseH, nxv1, nvb1, nvh1, fixparams, maxits, 
          workprec, precgoal, accgoal, modulus, zerotest];
			If[out =!= $Failed, Return[MakeOutputList[ZOne, out]]],
			model ===SingleZOne,
			nx1 = N[x1, workprec]; nt1 = N[t1, workprec];
			nxv1 = N[xv1, workprec];
			nvb1 = N[vb1, workprec]; nvh1 = N[vh1, workprec];
			out = SegAnalysis`SingleZOne`Private`mnlr[nptsA, nptsB, nptsH, nresponseA, 
          nresponseB, nresponseH, nx1, nt1, nxv1, nvb1, nvh1, fixparams, 
          maxits, workprec, precgoal, accgoal, modulus, zerotest];
			If[out =!= $Failed, Return[MakeOutputList[SingleZOne, out]]],
			model ===ZTwo,
			nxv1 = N[xv1, workprec];
			nvb1 = N[vb1, workprec]; nvh1 = N[vh1, workprec];
			nxv2 = N[xv2, workprec];
			nvb2 = N[vb2, workprec]; nvh2 = N[vh2, workprec];
			out = SegAnalysis`ZTwo`Private`mnlr[nptsA, nptsB, nptsH, nresponseA, 
          nresponseB, nresponseH, nxv1, nvb1, nvh1, nxv2, nvb2, nvh2, 
          fixparams, maxits, workprec, precgoal, accgoal, modulus, zerotest];
			If[out =!= $Failed, Return[MakeOutputList[ZTwo, out]]]
		];
	] (*  end of segregAnalysis *)

(* ============  MakeOutPutList  ============== *)
	
MakeOutputList[model_, out_] := 
  Block[
		{x, chisq, param, x1, t1, x2, t2, x3, t3, x4, t4, x5, t5, x6, t6, xv1, vb1, 
      vh1, xv2, vb2, vh2, paramerr, errx1, errt1, errx2, errt2, errx3, errt3, 
      errx4, errt4, errx5, errt5, errx6, errt6, errxv1, errvb1, errvh1, 
      errxv2, errvb2, errvh2, errorDOF},
		{chisq, param, paramerr, errorDOF, fp} = out;
		Which[
			model === Single,
			{x1, t1} = param;
			If[!(MemberQ[fp, "x1"]),errx1=First[paramerr];
				paramerr=Rest[paramerr], errx1=0];
			If[!(MemberQ[fp, "t1"]),errt1=First[paramerr], errt1=0];
			Print[ "The model is a single gametophyte gene."];
			If[fp=!={},Print["The fixed parameters are ",fp]];
			Print[StringForm["The gene position is at `1` \[PlusMinus] `2` .", 
          NumberForm[x1, 6], NumberForm[errx1, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete at the gene is `` \[PlusMinus] \
`` .", NumberForm[t1, 6], NumberForm[errt1, 6]]];
			Print[StringForm[
          "The number of analysed data is `1`.  The root mean square is `2`.",
           NumberForm[errorDOF + 2-Length[fp], 6], 
          NumberForm[Sqrt[chisq/errorDOF], 6]]],
			model === Two,
			{x1, t1, x2, t2} = param;
			If[!(MemberQ[fp, "x1"]),errx1=First[paramerr];
				paramerr=Rest[paramerr], errx1=0];
			If[!(MemberQ[fp, "t1"]),errt1=First[paramerr];paramerr=Rest[paramerr], 
        errt1=0];
			If[!(MemberQ[fp, "x2"]),errx2=First[paramerr];
				paramerr=Rest[paramerr], errx2=0];
			If[!(MemberQ[fp, "t2"]),errt2=First[paramerr], errt2=0];
			Print["The model is two genes on the same gamete."];
			If[fp=!={},Print["The fixed parameters are ",fp]];
			Print[StringForm[
          "The gene position of one gene is at `` \[PlusMinus] `` .", 
          NumberForm[x1, 6], NumberForm[errx1, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the gene is `` \[PlusMinus] \
`` .", NumberForm[t1, 6], NumberForm[errt1, 6]]];
			Print[StringForm[
          "The gene position of another gene is at `` \[PlusMinus] `` .", 
          NumberForm[x2, 6], NumberForm[errx2, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by another gene is `` \
\[PlusMinus] `` .", NumberForm[t2, 6], NumberForm[errt2, 6]]];
			Print[StringForm[
          "The number of analysed data is `1`.   The root mean square is \
`2`.", NumberForm[errorDOF + 4-Length[fp], 6], 
          NumberForm[Sqrt[chisq/errorDOF], 6]]],
			model === OneOne,
			{x1, t1, x2, t2} = param;
			If[!(MemberQ[fp, "x1"]),errx1=First[paramerr];
				paramerr=Rest[paramerr], errx1=0];
			If[!(MemberQ[fp, "t1"]),errt1=First[paramerr];paramerr=Rest[paramerr], 
        errt1=0];
			If[!(MemberQ[fp, "x2"]),errx2=First[paramerr];
				paramerr=Rest[paramerr], errx2=0];
			If[!(MemberQ[fp, "t2"]),errt2=First[paramerr], errt2=0];
			Print["The model is two genes on the different gametes."];
			If[fp=!={},Print["The fixed parameters are ",fp]];
			Print[StringForm[
          "The gene position of one gene is at `` \[PlusMinus] `` .", 
          NumberForm[x1, 6], NumberForm[errx1, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the gene is `` \[PlusMinus] \
`` .", NumberForm[t1, 6], NumberForm[errt1, 6]]];
			Print[StringForm[
          "The gene position of another gene is at `` \[PlusMinus] `` .", 
          NumberForm[x2, 6], NumberForm[errx2, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by another gene is `` \
\[PlusMinus] `` .", NumberForm[t2, 6], NumberForm[errt2, 6]]];
			Print[StringForm[
          "The number of analysed data is `1`.   The root mean square is \
`2`.", NumberForm[errorDOF + 4-Length[fp], 6], 
          NumberForm[Sqrt[chisq/errorDOF], 6]]],
			model === TwoOne,
			{x1, t1, x2, t2, x3, t3} = param;
			If[!(MemberQ[fp, "x1"]),errx1=First[paramerr];
				paramerr=Rest[paramerr], errx1=0];
			If[!(MemberQ[fp, "t1"]),errt1=First[paramerr];paramerr=Rest[paramerr], 
        errt1=0];
			If[!(MemberQ[fp, "x2"]),errx2=First[paramerr];
				paramerr=Rest[paramerr], errx2=0];
			If[!(MemberQ[fp, "t2"]),errt2=First[paramerr];paramerr=Rest[paramerr], 
        errt2=0];
			If[!(MemberQ[fp, "x3"]),errx3=First[paramerr];
				paramerr=Rest[paramerr], errx3=0];
			If[!(MemberQ[fp, "t3"]),errt3=First[paramerr], errt3=0];
			Print["The model is three genes, two genes on the same gamete and another \
gene on the other gamete."];
			If[fp=!={},Print["The fixed parameters are ",fp]];
			Print[StringForm["The first gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x1, 6], NumberForm[errx1, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the gene is `` \[PlusMinus] \
`` .", NumberForm[t1, 6], NumberForm[errt1, 6]]];
			Print[StringForm["The second gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x2, 6], NumberForm[errx2, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the second gene is `` \
\[PlusMinus] `` .", NumberForm[t2, 6], NumberForm[errt2, 6]]];
			Print[StringForm[
          "The third gene position on the other gamete is at `` \[PlusMinus] \
`` .", NumberForm[x3, 6], NumberForm[errx3, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the third gene is `` \
\[PlusMinus] `` .", NumberForm[t3, 6], NumberForm[errt3, 6]]];
			Print[StringForm[
          "The number of analysed data is `1`.   The root mean square is \
`2`.", NumberForm[errorDOF + 6-Length[fp], 6], 
          NumberForm[Sqrt[chisq/errorDOF], 6]]],
			model === TwoTwo,
			{x1, t1, x2, t2, x3, t3, x4, t4} = param;
			If[!(MemberQ[fp, "x1"]),errx1=First[paramerr];
				paramerr=Rest[paramerr], errx1=0];
			If[!(MemberQ[fp, "t1"]),errt1=First[paramerr];paramerr=Rest[paramerr], 
        errt1=0];
			If[!(MemberQ[fp, "x2"]),errx2=First[paramerr];
				paramerr=Rest[paramerr], errx2=0];
			If[!(MemberQ[fp, "t2"]),errt2=First[paramerr];paramerr=Rest[paramerr], 
        errt2=0];
			If[!(MemberQ[fp, "x3"]),errx3=First[paramerr];
				paramerr=Rest[paramerr], errx3=0];
			If[!(MemberQ[fp, "t3"]),errt3=First[paramerr];paramerr=Rest[paramerr], 
        errt3=0];
			If[!(MemberQ[fp, "x4"]),errx4=First[paramerr];
				paramerr=Rest[paramerr], errx4=0];
			If[!(MemberQ[fp, "t4"]),errt4=First[paramerr], errt4=0];
			Print["The model is four genes, two genes on the same gamete and the other \
two genes on the other gamete."];
			If[fp=!={},Print["The fixed parameters are ",fp]];
			Print[StringForm["The first gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x1, 6], NumberForm[errx1, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the gene is `` \[PlusMinus] \
`` .", NumberForm[t1, 6], NumberForm[errt1, 6]]];
			Print[StringForm["The second gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x2, 6], NumberForm[errx2, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the second gene is `` \
\[PlusMinus] `` .", NumberForm[t2, 6], NumberForm[errt2, 6]]];
			Print[StringForm[
          "The third gene position on the other gamete is at `` \[PlusMinus] \
`` .", NumberForm[x3, 6], NumberForm[errx3, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the third gene is `` \
\[PlusMinus] `` .", NumberForm[t3, 6], NumberForm[errt3, 6]]];
			Print[StringForm[
          "The fourth gene position on the other gamete is at `` \[PlusMinus] \
`` .", NumberForm[x4, 6], NumberForm[errx4, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the fourth gene is `` \
\[PlusMinus] `` .", NumberForm[t4, 6], NumberForm[errt4, 6]]];
			Print[StringForm[
          "The number of analysed data is `1`.   The root mean square is \
`2`.", NumberForm[errorDOF + 8-Length[fp], 6], 
          NumberForm[Sqrt[chisq/errorDOF], 6]]],
			model === ThreeOne,
			{x1, t1, x2, t2, x3, t3, x4, t4} = param;
			If[!(MemberQ[fp, "x1"]),errx1=First[paramerr];
				paramerr=Rest[paramerr], errx1=0];
			If[!(MemberQ[fp, "t1"]),errt1=First[paramerr];paramerr=Rest[paramerr], 
        errt1=0];
			If[!(MemberQ[fp, "x2"]),errx2=First[paramerr];
				paramerr=Rest[paramerr], errx2=0];
			If[!(MemberQ[fp, "t2"]),errt2=First[paramerr];paramerr=Rest[paramerr], 
        errt2=0];
			If[!(MemberQ[fp, "x3"]),errx3=First[paramerr];
				paramerr=Rest[paramerr], errx3=0];
			If[!(MemberQ[fp, "t3"]),errt3=First[paramerr];paramerr=Rest[paramerr], 
        errt3=0];
			If[!(MemberQ[fp, "x4"]),errx4=First[paramerr];
				paramerr=Rest[paramerr], errx4=0];
			If[!(MemberQ[fp, "t4"]),errt4=First[paramerr], errt4=0];
			Print["The model is four genes, three genes on the same gamete and another \
gene on the other gamete."];
			If[fp=!={},Print["The fixed parameters are ",fp]];
			Print[StringForm["The first gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x1, 6], NumberForm[errx1, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the gene is `` \[PlusMinus] \
`` .", NumberForm[t1, 6], NumberForm[errt1, 6]]];
			Print[StringForm["The second gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x2, 6], NumberForm[errx2, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the second gene is `` \
\[PlusMinus] `` .", NumberForm[t2, 6], NumberForm[errt2, 6]]];
			Print[StringForm[
          "The third gene position on the other gamete is at `` \[PlusMinus] \
`` .", NumberForm[x3, 6], NumberForm[errx3, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the third gene is `` \
\[PlusMinus] `` .", NumberForm[t3, 6], NumberForm[errt3, 6]]];
			Print[StringForm[
          "The fourth gene position on the other gamete is at `` \[PlusMinus] \
`` .", NumberForm[x4, 6], NumberForm[errx4, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the fourth gene is `` \
\[PlusMinus] `` .", NumberForm[t4, 6], NumberForm[errt4, 6]]];
			Print[StringForm[
          "The number of analysed data is `1`.   The root mean square is \
`2`.", NumberForm[errorDOF + 8-Length[fp], 6], 
          NumberForm[Sqrt[chisq/errorDOF], 6]]],
			model === ThreeTwo,
			{x1, t1, x2, t2, x3, t3, x4, t4, x5, t5} = param;
			If[!(MemberQ[fp, "x1"]),errx1=First[paramerr];
				paramerr=Rest[paramerr], errx1=0];
			If[!(MemberQ[fp, "t1"]),errt1=First[paramerr];paramerr=Rest[paramerr], 
        errt1=0];
			If[!(MemberQ[fp, "x2"]),errx2=First[paramerr];
				paramerr=Rest[paramerr], errx2=0];
			If[!(MemberQ[fp, "t2"]),errt2=First[paramerr];paramerr=Rest[paramerr], 
        errt2=0];
			If[!(MemberQ[fp, "x3"]),errx3=First[paramerr];
				paramerr=Rest[paramerr], errx3=0];
			If[!(MemberQ[fp, "t3"]),errt3=First[paramerr];paramerr=Rest[paramerr], 
        errt3=0];
			If[!(MemberQ[fp, "x4"]),errx4=First[paramerr];
				paramerr=Rest[paramerr], errx4=0];
			If[!(MemberQ[fp, "t4"]),errt4=First[paramerr];paramerr=Rest[paramerr], 
        errt4=0];
			If[!(MemberQ[fp, "x5"]),errx5=First[paramerr];
				paramerr=Rest[paramerr], errx5=0];
			If[!(MemberQ[fp, "t5"]),errt5=First[paramerr], errt5=0];
			Print["The model is five genes, three genes on the same gamete and the \
other two genes on the other gamete."];
			If[fp=!={},Print["The fixed parameters are ",fp]];
			Print[StringForm["The first gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x1, 6], NumberForm[errx1, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the gene is `` \[PlusMinus] \
`` .", NumberForm[t1, 6], NumberForm[errt1, 6]]];
			Print[StringForm["The second gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x2, 6], NumberForm[errx2, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the second gene is `` \
\[PlusMinus] `` .", NumberForm[t2, 6], NumberForm[errt2, 6]]];
			Print[StringForm["The third gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x3, 6], NumberForm[errx3, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the third gene is `` \
\[PlusMinus] `` .", NumberForm[t3, 6], NumberForm[errt3, 6]]];
			Print[StringForm[
          "The fourth gene position on the other gamete is at `` \[PlusMinus] \
`` .", NumberForm[x4, 6], NumberForm[errx4, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the fourth gene is `` \
\[PlusMinus] `` .", NumberForm[t4, 6], NumberForm[errt4, 6]]];
			Print[StringForm[
          "The fifth gene position on the other gamete is at `` \[PlusMinus] \
`` .", NumberForm[x5, 6], NumberForm[errx5, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the fifth gene is `` \
\[PlusMinus] `` .", NumberForm[t5, 6], NumberForm[errt5, 6]]];
			Print[StringForm[
          "The number of analysed data is `1`.   The root mean square is \
`2`.", NumberForm[errorDOF + 10-Length[fp], 6], 
          NumberForm[Sqrt[chisq/errorDOF], 6]]],
			model === ThreeThree,
			{x1, t1, x2, t2, x3, t3, x4, t4, x5, t5, x6, t6} = param;
			If[!(MemberQ[fp, "x1"]),errx1=First[paramerr];
				paramerr=Rest[paramerr], errx1=0];
			If[!(MemberQ[fp, "t1"]),errt1=First[paramerr];paramerr=Rest[paramerr], 
        errt1=0];
			If[!(MemberQ[fp, "x2"]),errx2=First[paramerr];
				paramerr=Rest[paramerr], errx2=0];
			If[!(MemberQ[fp, "t2"]),errt2=First[paramerr];paramerr=Rest[paramerr], 
        errt2=0];
			If[!(MemberQ[fp, "x3"]),errx3=First[paramerr];
				paramerr=Rest[paramerr], errx3=0];
			If[!(MemberQ[fp, "t3"]),errt3=First[paramerr];paramerr=Rest[paramerr], 
        errt3=0];
			If[!(MemberQ[fp, "x4"]),errx4=First[paramerr];
				paramerr=Rest[paramerr], errx4=0];
			If[!(MemberQ[fp, "t4"]),errt4=First[paramerr];paramerr=Rest[paramerr], 
        errt4=0];
			If[!(MemberQ[fp, "x5"]),errx5=First[paramerr];
				paramerr=Rest[paramerr], errx5=0];
			If[!(MemberQ[fp, "t5"]),errt5=First[paramerr];paramerr=Rest[paramerr], 
        errt5=0];
			If[!(MemberQ[fp, "x6"]),errx6=First[paramerr];
				paramerr=Rest[paramerr], errx6=0];
			If[!(MemberQ[fp, "t6"]),errt6=First[paramerr], errt6=0];
			Print["The model is six genes, three genes on the same gamete and the \
other three genes on the other gamete."];
			If[fp=!={},Print["The fixed parameters are ",fp]];
			Print[StringForm["The first gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x1, 6], NumberForm[errx1, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the gene is `` \[PlusMinus] \
`` .", NumberForm[t1, 6], NumberForm[errt1, 6]]];
			Print[StringForm["The second gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x2, 6], NumberForm[errx2, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the second gene is `` \
\[PlusMinus] `` .", NumberForm[t2, 6], NumberForm[errt2, 6]]];
			Print[StringForm["The third gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x3, 6], NumberForm[errx3, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the third gene is `` \
\[PlusMinus] `` .", NumberForm[t3, 6], NumberForm[errt3, 6]]];
			Print[StringForm[
          "The fourth gene position on the other gamete is at `` \[PlusMinus] \
`` .", NumberForm[x4, 6], NumberForm[errx4, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the fourth gene is `` \
\[PlusMinus] `` .", NumberForm[t4, 6], NumberForm[errt4, 6]]];
			Print[StringForm[
          "The fifth gene position on the other gamete is at `` \[PlusMinus] \
`` .", NumberForm[x5, 6], NumberForm[errx5, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the fifth gene is `` \
\[PlusMinus] `` .", NumberForm[t5, 6], NumberForm[errt5, 6]]];
			Print[StringForm[
          "The sixth gene position on the other gamete is at `` \[PlusMinus] \
`` .", NumberForm[x6, 6], NumberForm[errx6, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the sixth gene is `` \
\[PlusMinus] `` .", NumberForm[t6, 6], NumberForm[errt6, 6]]];
			Print[StringForm[
          "The number of analysed data is `1`.   The root mean square is \
`2`.", NumberForm[errorDOF + 12-Length[fp], 6], 
          NumberForm[Sqrt[chisq/errorDOF], 6]]],
			model === ZOne,
			{xv1, vb1, vh1} = param;
			If[!(MemberQ[fp, "xv1"]),errxv1=First[paramerr];paramerr=Rest[paramerr], 
        errxv1=0];
			If[!(MemberQ[fp, "vb1"]),errvb1=First[paramerr];
				paramerr=Rest[paramerr], errvb1=0];
			If[!(MemberQ[fp, "vh1"]),errvh1=First[paramerr], errvh1=0];
			Print["The model is a single gene that affects viabilities of zygotes"];
			If[fp=!={},Print["The fixed parameters are ",fp]];
			Print[StringForm["The gene position is at `` \[PlusMinus] `` .", 
          NumberForm[xv1, 6], NumberForm[errxv1, 6]]];
			Print[StringForm[
          "The relative viability of B homozygote is `` \[PlusMinus] `` .", 
          NumberForm[vb1, 6], NumberForm[errvb1, 6]]];
			Print[StringForm[
          "The relative viability of heterozygote is `` \[PlusMinus] `` .", 
          NumberForm[vh1, 6], NumberForm[errvh1, 6]]];
			Print[StringForm[
          "The number of analysed data is `1`.   The root mean square is \
`2`.", NumberForm[errorDOF + 3-Length[fp], 6], 
          NumberForm[Sqrt[chisq/errorDOF], 6]]],
			model === SingleZOne,
			{x1, t1, xv1, vb1, vh1} = param;
			If[!(MemberQ[fp, "x1"]),errx1=First[paramerr];
				paramerr=Rest[paramerr], errx1=0];
			If[!(MemberQ[fp, "t1"]),errt1=First[paramerr];paramerr=Rest[paramerr], 
        errt1=0];
			If[!(MemberQ[fp, "xv1"]),errxv1=First[paramerr];paramerr=Rest[paramerr], 
        errxv1=0];
			If[!(MemberQ[fp, "vb1"]),errvb1=First[paramerr];
				paramerr=Rest[paramerr], errvb1=0];
			If[!(MemberQ[fp, "vh1"]),errvh1=First[paramerr], errvh1=0];
			Print["The model is a single gametophyte gene and a single zygotic \
viability gene."];
			If[fp=!={},Print["The fixed parameters are ",fp]];
			Print[StringForm[
          "The gametophyte gene position is at `` \[PlusMinus] `` .", 
          NumberForm[x1, 6], NumberForm[errx1, 6]]];
			Print[StringForm[
          "The transmittance of the A gamete by the gene is `` \[PlusMinus] \
`` .", NumberForm[t1, 6], NumberForm[errt1, 6]]];
			Print[StringForm[
          "The zygotic viability gene position is at `` \[PlusMinus] `` .", 
          NumberForm[xv1, 6], NumberForm[errxv1, 6]]];
			Print[StringForm[
          "The relative viability of B homozygote is `` \[PlusMinus] `` .", 
          NumberForm[vb1, 6], NumberForm[errvb1, 6]]];
			Print[StringForm[
          "The relative viability of heterozygote is `` \[PlusMinus] `` .", 
          NumberForm[vh1, 6], NumberForm[errvh1, 6]]];
			Print[StringForm[
          "The number of analysed data is `1`.   The root mean square is \
`2`.", NumberForm[errorDOF + 5-Length[fp], 6], 
          NumberForm[Sqrt[chisq/errorDOF], 6]]],
			model === ZTwo,
			{xv1, vb1, vh1, xv2, vb2, vh2} = param;
			If[!(MemberQ[fp, "xv1"]),errxv1=First[paramerr];paramerr=Rest[paramerr], 
        errxv1=0];
			If[!(MemberQ[fp, "vb1"]),errvb1=First[paramerr];
				paramerr=Rest[paramerr], errvb1=0];
			If[!(MemberQ[fp, "vh1"]),errvh1=First[paramerr];paramerr=Rest[paramerr], 
        errvh1=0];
			If[!(MemberQ[fp, "xv2"]),errxv2=First[paramerr];paramerr=Rest[paramerr], 
        errxv2=0];
			If[!(MemberQ[fp, "vb2"]),errvb2=First[paramerr];
				paramerr=Rest[paramerr], errvb2=0];
			If[!(MemberQ[fp, "vh2"]),errvh2=First[paramerr], errvh2=0];
			Print["The model is two genes that affects viabilities of zygotes"];
			If[fp=!={},Print["The fixed parameters are ",fp]];
			Print[StringForm["The first gene position is at `` \[PlusMinus] `` .", 
          NumberForm[xv1, 6], NumberForm[errxv1, 6]]];
			Print[StringForm[
          "The relative viability of B homozygote at the first gene is `` \
\[PlusMinus] `` .", NumberForm[vb1, 6], NumberForm[errvb1, 6]]];
			Print[StringForm[
          "The relative viability of heterozygote at the first gene is `` \
\[PlusMinus] `` .", NumberForm[vh1, 6], NumberForm[errvh1, 6]]];
			Print[StringForm["The second gene position is at `` \[PlusMinus] `` .", 
          NumberForm[xv2, 6], NumberForm[errxv2, 6]]];
			Print[StringForm[
          "The relative viability of B homozygote at the second gene is `` \
\[PlusMinus] `` .", NumberForm[vb2, 6], NumberForm[errvb2, 6]]];
			Print[StringForm[
          "The relative viability of heterozygote at the second gene is `` \
\[PlusMinus] `` .", NumberForm[vh2, 6], NumberForm[errvh2, 6]]];
			Print[StringForm[
          "The number of analysed data is `1`.   The root mean square is \
`2`.", NumberForm[errorDOF + 6-Length[fp], 6], 
          NumberForm[Sqrt[chisq/errorDOF], 6]]]
			] (* Which[model === Single,   *)
	] (* end MakeOutputList   *)
		

End[]

EndPackage[]
